/************************************************************************
 * NAME:	hdos.h
 *
 * DESCR:	defines for the HDOS file system.
 *
 * NOTES:	
 ************************************************************************/
#include <stdio.h>
#include "standard.h"
#include "date.h"
#include "label.h"
#include "dir.h"
#include "fileio.h"
#include "hdosio.h"
#include "physio.h"
#include "groupio.h"

/*
 * shortcuts for accessing attributes of the disk
 */

#define HDOS_DIRLOC(h)		((h)->labelbuf.dirsec)
#define HDOS_GRTLOC(h)		((h)->labelbuf.grtsec)
#define HDOS_RGTLOC(h)		((h)->labelbuf.rgtsec)
#define HDOS_GROUPSIZE(h)	((h)->labelbuf.grpsize)
#define HDOS_SECTSIZE(h)	((h)->labelbuf.physize)
#define HDOS_TRACKS(h)		((h)->labelbuf.tracks)
#define HDOS_SIDES(h)		((h)->labelbuf.sides)
#define HDOS_SECTORS(h)		((h)->labelbuf.secs)

/*
 * derived values for the disk
 */

#define HDOS_GROUPS(h)		(HDOS_TRACKS(h)*HDOS_SECTORS(h)*HDOS_SIDES(h)/HDOS_GROUPSIZE(h))
#define HDOS_SIZEBYTES(h)	(HDOS_TRACKS(h)*HDOS_SECTORS(h)*HDOS_SIDES(h)*HDOS_SECTSIZE(h))

/*
 * other special macros
 */

#define HDOS_NORGT(h)		((h)->labelbuf.rgtsec == 0)


extern int hdos_dir_read(struct hdosfs *);
extern int hdos_dir_write(struct hdosfs *);
extern void hdos_dir_report(struct hdosfs *, int);
extern char *hdos_label_report(struct hdosfs *, char *, int);
